/*------------------------------------------------------------------------------*
 * File Name: ListDataSets.h				 									*
 * Creation: GJL 11/17/03 														*
 * Purpose: OriginC header file containing ListDataSets example dialog.			*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007		 		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

// ListDataSets Dialog derived class
class ListDataSets : public Dialog
{
public:

	// Constructor
	ListDataSets() : Dialog(IDD_LDS_DLG, "ListDataSets") { }

	// Launch dialog
	int DoModal(HWND hParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}

protected:

	// Message Map
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_OK(OnOK)
		ON_LBN_SELCHANGE(IDC_LDS_LIST1,OnSelChangeLBX)
	EVENTS_END
	
	// Initialize dialog and list box
	BOOL OnInitDialog()
	{
		string strDataName;
		m_lbxAvailableData = GetItem(IDC_LDS_LIST1);

		// Loop through all data set names in project
		foreach(strDataName in Project.DatasetNames)
		{
			m_lbxAvailableData.AddString(strDataName); // Add name to list box
		}
		
		return TRUE;
	}

	// Output selected item in list box
	BOOL OnOK()
	{
		int index;
		string strDataName, strOut;
		
		index = m_lbxAvailableData.GetCurSel(); // Get selected item's index
		m_lbxAvailableData.GetText(index, strDataName); // Get selected item's text

		if( !strDataName.IsEmpty() )
		{
			strOut.Format("You clicked OK with the data set %s selected.\n", strDataName);
			strOut.Write(WRITE_MESSAGE_BOX);
		}

		return TRUE;
	}


	BOOL OnSelChangeLBX(Control ctrl)
	{
		int index;
		string strDataName, strOut;
		
		index = m_lbxAvailableData.GetCurSel(); // Get selected item's index
		m_lbxAvailableData.GetText(index, strDataName); // Get selected item's text

		if( !strDataName.IsEmpty() )
		{
			strOut.Format("You selected the data set %s.\n", strDataName);
			strOut.Write(WRITE_MESSAGE_BOX);
		}

		return TRUE;
	}
	
private:
	ListBox m_lbxAvailableData; // ListBox control
};